<?php

if( !class_exists('Royal_Soon_Product_Frontend_Functions') ) {

	class Royal_Soon_Product_Frontend_Functions {

		public function __construct() {

			// Add Soon Checkbox Option To Edit Product Metabox
			add_filter( 'product_type_options', array($this, 'add_soon_product_option') );
			add_filter( 'product_type_options', array($this, 'add_not_avalibale_product_option') );

			// Save Soon Product User Emails
			add_action( 'woocommerce_process_product_meta_simple', array($this, 'save_product_option_fields') );
			add_action( 'woocommerce_process_product_meta_variable', array($this, 'save_product_option_fields') );

		}

		/**
		 * Add 'soon ' product option
		**/
		public function add_soon_product_option( $product_type_options ) {

			$product_type_options['sj_soon_product'] = array(
				'id'            => '_sj_soon_product',
				'wrapper_class' => 'show_if_simple show_if_variable',
				'label'         => __( 'Soon Product', 'royal' ),
				'description'   => __( 'This product will be available soon.', 'royal' ),
				'default'       => 'no'
			);

			return $product_type_options;

		}

		/**
		 * Add 'soon ' product option
		**/
		public function add_not_avalibale_product_option( $product_type_options ) {

			$product_type_options['sj_not_avalible_product'] = array(
				'id'            => '_sj_not_avalible_product',
				'wrapper_class' => 'show_if_simple show_if_variable',
				'label'         => __( 'Not available', 'royal' ),
				'description'   => __( 'This product is not available', 'royal' ),
				'default'       => 'no'
			);

			return $product_type_options;

		}

		/**
		 * Save the custom fields.
		**/
		function save_product_option_fields( $post_id ) {

			// Save the soon product.
			$is_soon_product = isset( $_POST['_sj_soon_product'] ) ? 'yes' : 'no';
			update_post_meta( $post_id, '_sj_soon_product', $is_soon_product );

			// Save the not avalibale product.
			$is_not_avalible_product = isset( $_POST['_sj_not_avalible_product'] ) ? 'yes' : 'no';
			update_post_meta( $post_id, '_sj_not_avalible_product', $is_not_avalible_product );

		}

	}new Royal_Soon_Product_Frontend_Functions();

}