<?php

if( !class_exists('Royal_WC_Soon_Product') ) {

	class Royal_WC_Soon_Product {
	    
	    protected $soon_product_dir = '';

		public function __construct() {

			$this->soon_product_dir = get_stylesheet_directory() . '/includes/soon-product/';

			// Add Soon Product Menu For Display All Email Registered
			add_action('admin_menu', array($this, 'register_my_custom_submenu_page'),99);

			// Load Create Table Query For Soon Product
			require_once( $this->soon_product_dir . '/sj-create-table.php' );
			require_once( $this->soon_product_dir . '/front_end_functions.php' );

		}

		public function register_my_custom_submenu_page() {

			$hook = add_submenu_page(
				'woocommerce',
				__( 'Soon Product' , 'royal' ),
				__( 'Soon Product' , 'royal' ),
				'manage_options',
				'sjsp_show_request',
				function(){ include ( $this->soon_product_dir . 'admin/show_request.php' ); } 
			);

		}

	}new Royal_WC_Soon_Product();

}