<?php

if( !class_exists('Royal_Video_Metabox') ) {

    class Royal_Video_Metabox {
        
        protected $royal_video_metabox_js_url = '';

        public function __construct() {

            // Royal Video Metabox DIR
            $this->royal_video_metabox_js_url = get_stylesheet_directory_uri() . '/includes/video-metabox/assets/js/';

            // add product video metabox
            add_action( 'add_meta_boxes' , array($this, 'add_metabox_product_screen') );

            // Save video MetaBox fields
            add_action( 'save_post' , array($this, 'iravada_update_video_field_data') );
            add_action( 'save_edit' , array($this, 'iravada_update_video_field_data') );
        }

        // add product video metabox Function
        public function add_metabox_product_screen() {

            add_meta_box( 
                'iravada_product_video_textbox',
                'ویدئو معرفی محصول', 
                function($post) {
                    $video_url = get_post_meta( $post->ID , '_iravada_get_product_video_url' , true );
                    ?>
                        <p>با استفاده از این باکس یک ویدئو کوتاه برای معرفی محصول وارد نمایید.</p>
                        <input type="text" style="width: 100%; margin-bottom: 10px;" name="_iravada_get_product_video_url" value="<?php echo esc_url($video_url); ?>" id="_iravada_get_product_video_url" />
                        <input type="button" style="width: 100%;" class="button-secondary" value="بارگذاری ویدئو" name="_select_video" id="iravada_select_video" />
                    <?php
                    wp_enqueue_script('iravada-upload-product-video', $this->royal_video_metabox_js_url . 'upload.js');
                },
                'product', 
                'side',
                'high'
            );
        }

        // Save video MetaBox fields
        public function iravada_update_video_field_data( $post_id ) {
            if( isset( $_POST['_iravada_get_product_video_url'] ) ) {
                update_post_meta( $post_id , '_iravada_get_product_video_url', esc_url_raw($_POST['_iravada_get_product_video_url']) );   
            }
        }

    }new Royal_Video_Metabox();
}