<?php

// Order by inStock 2000
class iWC_Orderby_inStock_Status {
    
	public function __construct() {
		// Check if WooCommerce is active
		if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {
		add_filter('posts_clauses', array($this, 'order_by_stock_status'), 2000);
		}
	}
	
	public function order_by_stock_status($posts_clauses) {
		global $wpdb;
	    global $woocommerce;
        global $product;
        global $post;
		// only change query on WooCommerce loops
		if (is_woocommerce() && ( is_archive() )) {
			$posts_clauses['join'] .= " INNER JOIN $wpdb->postmeta istockstatus ON ($wpdb->posts.ID = istockstatus.post_id) ";
			$posts_clauses['orderby'] = " istockstatus.meta_value ASC, " . $posts_clauses['orderby'];
			$posts_clauses['where'] = " AND istockstatus.meta_key = '_stock_status' AND istockstatus.meta_value <> '' " . $posts_clauses['where'];
		}
		return $posts_clauses;
	}
	
}
new iWC_Orderby_inStock_Status;

// Hide out of stock from related products
function hide_out_of_stock_option( $option ){
	return 'yes';
}

add_action( 'woocommerce_before_template_part', function( $template_name ) {
	if( $template_name !== "single-product/related.php" ) {
		return;
	}
	add_filter( 'pre_option_woocommerce_hide_out_of_stock_items', 'hide_out_of_stock_option' );
});

add_action( 'woocommerce_after_template_part', function( $template_name ) {
	if( $template_name !== "single-product/related.php" ) {
		return;
	}
	remove_filter( 'pre_option_woocommerce_hide_out_of_stock_items', 'hide_out_of_stock_option' );
});