<?php

if( !class_exists('Royal_WC_Sec_Title_Field') ) {

	class Royal_WC_Sec_Title_Field {

		public function __construct() {

			// add text field in product edit page before permalink action
			add_action( 'edit_form_before_permalink' , array($this, 'iravada_sec_title_for_product') ); 

			// save sec title content action
			add_action( 'woocommerce_process_product_meta', array($this, 'iravada_save_information_field') ); 

		}

		// add text field in product edit page before permalink action
		public function iravada_sec_title_for_product() {

			global $product;

			if ( get_post_type( get_the_ID() ) == 'product' ){
				woocommerce_wp_text_input(             
					array( 
						'id'            => 'iravada_sec_title', 
						'label'         => '',
						'placeholder'   => __( 'Enter the second product title in this field. Usually English.' , 'royal' ),
						'style'         => 'width: 100%;',
					)	    
				);
			}

		}

		// save sec title content action
		public function iravada_save_information_field( $post_id ) {

			if ( ! empty( $_POST['iravada_sec_title'] )) {
				update_post_meta( $post_id, 'iravada_sec_title', esc_attr( $_POST['iravada_sec_title'] ) );
			}elseif( empty( $_POST['iravada_sec_title'] ) ) {
				update_post_meta( $post_id, 'iravada_sec_title', '' );
			}

		}

	}new Royal_WC_Sec_Title_Field();

}