<?php


if( !class_exists('Royal_WC_Variable_Product_Price_Range') ) {

    class Royal_WC_Variable_Product_Price_Range {

        public function __construct() {

            // Disable Variable Product Price Range
            add_filter( 'woocommerce_variable_sale_price_html', array($this, 'wc_varb_price_range'), 10, 2 );
            add_filter( 'woocommerce_variable_price_html', array($this, 'wc_varb_price_range'), 10, 2 );

        }

        // Disable Variable Product Price Range
        public function wc_varb_price_range( $wcv_price, $product ) {
         
            $prefix = '<span class="irava-price-range">' . sprintf('%s ', __('From:', 'royal')) . '</span>';
         
            $wcv_reg_min_price = $product->get_variation_regular_price( 'min', true );
            $wcv_min_sale_price    = $product->get_variation_sale_price( 'min', true );
            $wcv_max_price = $product->get_variation_price( 'max', true );
            $wcv_min_price = $product->get_variation_price( 'min', true );
         
            $wcv_price = ( $wcv_min_sale_price == $wcv_reg_min_price ) ?
                wc_price( $wcv_reg_min_price ) :
                '<del>'  . wc_price( $wcv_reg_min_price ) . '</del>' . '<ins>' . $prefix . wc_price( $wcv_min_sale_price ) . '</ins>';
         
            return ( $wcv_min_price == $wcv_max_price ) ?
                $wcv_price :
                sprintf('%s%s', '', $wcv_price);
        }

    }new Royal_WC_Variable_Product_Price_Range();

}